# Persistence

The installed application INETAPP heavily depends on the persistence to store vital information. This information includes, e.g. configuration and user settings. The persistence can be stored in one of the following locations based on the scenario INETAPP is used in.

  * [File System Persistence](/documentation/shared/plugins/persistence/persistence/file-system)
  * [MongoDB Persistence](/documentation/shared/plugins/persistence/persistence/mongodb) 
  * [Azure CosmosDB SQL-API](/documentation/shared/plugins/persistence/persistence/cosmosdb)
  * [DynamoDB Persistence](/documentation/shared/plugins/persistence/persistence/dynamodb)

The default persistence is the *File System*. It suffices use cases of a local server installation with a fixed hard drive. *MongoDB* can be used out of the box in cloud-based environments where no hard drive is available, or the file system can disappear together with the server instance.

The persistence should be selected depending on the usage scenario.

  * The *File System* persistence can be used in every (server-) environment given that the underlying hard disk is always available (e.g. bare-bone server, Docker with mounted directories)
  * The *MongoDB* persistence is a hard disk backed persistence that can handle larger chunks of data easily. It should be used in cloud environments in a scenario that requires a large amount of data being stored. This persistence allows preserving the server configuration in environments where server can be spun up and down at will.
  * The *CosmosDB* persistence is an alternative cloud-based persistence created by Microsoft for Azure deployment. An alternative container is provided for this variant.
  * The *DynamoDB* persistence is an alternative cloud-based persistence created by Amazon for AWS deployment. An alternative container is provided for this variant.

 Running multiple node instances in a cluster requires one of the database persistence. It does not work with the *File System* persistence.

 Running multiple node instances in a cluster requires either a *Private Cloud license* or a *Public Cloud license*.

 When using a non-file persistence in a docker container, please also define the environment property `DEFAULT_CONFIG=System/Default`. A cloud-based persistence requires the configuration to be stored in a system scope.

## Configuration of the Persistence

The persistence is the first thing to be initialized when starting the server - before the actual configuration can be set. That is why the persistence has to be set up from the outside using one of the following methods.

 The [File System Persistence](/documentation/shared/plugins/persistence/persistence/file-system) persistence does not require any additional configuration.

### Properties File

A properties file can be created in the `plugins/persistence/` subfolder of the installation. It has to have the name `persistence.properties` with a single entry line:

```properties
inet_persistence=<PERSISTENCE URI>
```

With `<PERSISTENCE URI>` being the URI specific to the persistence.

### System Property

The system property has to be set when starting the INETAPP server, eg:

```bash
java -jar ... -Dinet_persistence=<PERSISTENCE URI>
```

With `<PERSISTENCE URI>` being the URI specific to the persistence.

### Environment Variable

The server will check for an environment variable of the name `inet_persistence` of neither properties file or system property are given. On Unix/Linux systems the variable could be set using:

```bash
export inet_persistence=<PERSISTENCE URI>
```

With `<PERSISTENCE URI>` being the URI specific to the persistence.

## Switching the persistence layer

Switching the persistence layer is not a standard task and should be considered carefully. To switch the persistence, make a full backup of INETAPP server using the Maintenance application and download the backup information.

You can then set up the server with the newly selected persistence store, upload the backup and restore it.

 switching to a non-file persistence with custom translations in place requires extra work to distribute the translations. For more information see: [Translations in the cloud](http://docs.inetsoftware.de/reporting/help/translations-in-the-cloud)

